/******************************************************************************

  Copyright (C) 2010 [Hilscher Gesellschaft für Systemautomation mbH]

  This program can be used by everyone according to the netX Open Source
  Software license. The license agreement can be downloaded from
  http://www.industrialNETworX.com

 ******************************************************************************

  Last Modification:
    @version $Id: ProfibusMPI_AP_Public.h 14422 2011-02-09 12:37:32Z AndreasB $

  Description:
    The header contains the public definition of task.
    It has to be included by another task to get access of task specific
    definition.

  Changes:
    Date        Author        Description
  ---------------------------------------------------------------------------
    2010-10-20  NC            File created.

******************************************************************************/
#ifndef __PROFIBUS_MPI_AP_PUBLIC_H
#define __PROFIBUS_MPI_AP_PUBLIC_H

#include "ProfibusDl_BusParameter.h"

/******************************************************************************
  Queue Name
    Use the queue name to identify the process queue of task.
******************************************************************************/
#define PROFIBUS_MPI_AP_QUEUE_NAME            "QUE_PB_MPI_AP"

/******************************************************************************
  Command numbers
******************************************************************************/
#define PROFIBUS_MPI_AP_CMD_SET_CONFIG_REQ          0x00004200
#define PROFIBUS_MPI_AP_CMD_SET_CONFIG_CNF          0x00004201

//#define PROFIBUS_MPI_AP_CMD_AUTO_BAUD_COMPLETE_IND  0x00004202
//#define PROFIBUS_MPI_AP_CMD_AUTO_BAUD_COMPLETE_RES  0x00004203
//
#define PROFIBUS_MPI_AP_CMD_WATCHDOG_TIMEOUT_IND    0x000042F0
#define PROFIBUS_MPI_AP_CMD_WATCHDOG_TIMEOUT_RES    0x000042F1

/* #define PROFIBUS_MPI_AP_CMD_APP_REG_REQ             0x0000420C obsolete packet */
/* #define PROFIBUS_MPI_AP_CMD_APP_REG_CNF             0x0000420D use RCX_REGISTER_APP_REQ */

/******************************************************************************
    Structure and defines for command numbers:
      - PROFIBUS_MPI_AP_CMD_SET_CONFIG_REQ
      - PROFIBUS_MPI_AP_CMD_SET_CONFIG_CNF
******************************************************************************/
#define PROFIBUS_MPI_AP_CONFIG_SYS_FLG_START_MASK         0x00000001
#define PROFIBUS_MPI_AP_CONFIG_SYS_FLG_START_AUTO         0x00000000
#define PROFIBUS_MPI_AP_CONFIG_SYS_FLG_START_APPLICATION  0x00000001

#define PROFIBUS_MPI_AP_CONFIG_WATCHDOG_OFF                  0
#define PROFIBUS_MPI_AP_CONFIG_WATCHDOG_MIN                 20
#define PROFIBUS_MPI_AP_CONFIG_WATCHDOG_MAX              65535

typedef struct PROFIBUS_MPI_AP_SET_CONFIG_DATA_Ttag
{
  TLR_UINT32                      ulSystemFlag;
  TLR_UINT32                      ulWdgTime;
  PROFIBUS_DL_BUS_PARAMETER_SET_T tBusParameter;
} PROFIBUS_MPI_AP_SET_CONFIG_DATA_T;

typedef struct PROFIBUS_MPI_AP_PACKET_SET_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  PROFIBUS_MPI_AP_SET_CONFIG_DATA_T tData;
} PROFIBUS_MPI_AP_PACKET_SET_CONFIG_REQ_T;

typedef struct PROFIBUS_MPI_AP_PACKET_SET_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} PROFIBUS_MPI_AP_PACKET_SET_CONFIG_CNF_T;

///******************************************************************************
//    Structure and defines for command numbers:
//      - PROFIBUS_MPI_AP_CMD_AUTO_BAUD_COMPLETE_IND
//      - PROFIBUS_MPI_AP_CMD_AUTO_BAUD_COMPLETE_RES
//******************************************************************************/
//typedef TLR_EMPTY_PACKET_T PROFIBUS_MPI_AP_AUTO_BAUD_COMPLETE_IND_T;
//typedef TLR_EMPTY_PACKET_T PROFIBUS_MPI_AP_AUTO_BAUD_COMPLETE_RES_T;

#endif /* __PROFIBUS_MPI_AP_PUBLIC_H */
